<?php
/**
 * Fallback for Menu Icons walker to handle conflict with ACF Walker.
 *
 * @link https://wordpress.org/plugins/menu-icons/
 *
 * @package JupiterX\Framework\Admin\Menu
 *
 * @since   1.19.0
 */

if ( ! class_exists( 'Walker_Nav_Menu_Edit' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-walker-nav-menu-edit.php';
}

/**
 * Fallback Menu Icons Custom Walker for Nav Menu Editor
 *
 * We're separating this class from the plugin file because Walker_Nav_Menu_Edit
 * is only loaded on the wp-admin/nav-menus.php page.
 *
 * Based on {@link https://twitter.com/westonruter Weston Ruter}'s {@link https://gist.github.com/3802459 gist}
 *
 * @package Menu_Item_Custom_Fields
 * @version 1.0.0
 * @author Dzikri Aziz <kvcrvt@gmail.com>
 */
class Menu_Item_Custom_Fields_Walker extends Walker_Nav_Menu_Edit {

	/**
	 * Start the element output.
	 *
	 * We're injecting our custom fields after the div.submitbox
	 *
	 * @see Walker_Nav_Menu::start_el()
	 * @since 0.1.0
	 * @since 0.2.0 Update regex pattern to support WordPress 4.7's markup.
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item   Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args   Menu item args.
	 * @param int    $id     Nav menu ID.
	 */
	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$item_output = '';

		parent::start_el( $item_output, $item, $depth, $args, $id );

		$output .= preg_replace(
			// NOTE: Check this regex from time to time!
			'/(?=<(fieldset|p)[^>]+class="[^"]*field-move)/',
			$this->get_fields(),
			$item_output
		);
	}


	/**
	 * Get custom fields
	 *
	 * @access protected
	 * @since 0.1.0
	 *
	 * @return string Form fields
	 */
	protected function get_fields() {
		return '';
	}
}
